<!DOCTYPE HTML>
<?PHP
	require 'functions.php';
	checkLogin();
	$db_link = connect();
	$timestamp = time(); //Generate timestamp
  
    $empl_idget = $_GET['empl']; // get url parameter emplayeee id
    $loanLineID = $_GET['lrid']; // get url parameter Loan Line ID

    $lStatus = '2'; // Default loan status : "ACTIVE"
    if(isset($_GET['lStatus'])) { // get url parameter loan status
        $lStatus = $_GET['lStatus'];    }
    switch ($lStatus) {
    case 1:
        $lStatusHeading = "PENDING";
    break;
    case 2:
        $lStatusHeading = "ACTIVE";
    break;
    case 3:
        $lStatusHeading = "REFUSED";
    break;
    case 4:
        $lStatusHeading = "ABANDONED";
    break;
    case 5:
        $lStatusHeading = "CLEARED";
    break;  }
    
    $rep_year = date("Y",time());
	$rep_month = date("m",time());

	//Make array for exporting data
	$_SESSION['rep_export'] = array();
	$_SESSION['rep_exp_title'] = $rep_year.'-'.$rep_month.'_loans-active';
    
    /* get user id from empl id*/
    $sql_uidFemplID =  " SELECT user_id FROM user WHERE empl_id = $empl_idget";
    $row_uidFemplID = mysqli_fetch_assoc( mysqli_query($db_link, $sql_uidFemplID));
    $uidFemplID =  $row_uidFemplID['user_id'];

	//Select Loans from LOANS
	$sql_loans = "SELECT * FROM loans LEFT JOIN loanstatus ON loans.loanstatus_id = loanstatus.loanstatus_id LEFT JOIN customer ON loans.cust_id = customer.cust_id WHERE loans.loanstatus_id = $lStatus AND loans.user_id =  $uidFemplID AND lroute_id = $loanLineID ORDER BY loan_dateout, loans.cust_id";
	$query_loans = mysqli_query($db_link, $sql_loans);
	checkSQL($db_link, $query_loans);
?>
<html>
	<?PHP includeHead('Loans',1) ?>
</head>
<body>
		<!-- MENU -->
        <!-- Main Menu -->
		<?PHP includeMenu(3);	?> 
        <!-- Sub Menu -->
		<div id="menu_main"> 
            <a href="employee.php?empl=<?PHP echo $empl_idget ?>">Back</a>
            <a href="loanroute.php?lrid=<?php echo $loanLineID; ?>&&empl=<?php echo $empl_idget; ?>&&lStatus=2" >Active Loans</a>
			<a href="loanroute.php?lrid=<?php echo $loanLineID; ?>&&empl=<?php echo $empl_idget; ?>&&lStatus=1" >Pending Loans</a>
            <a href="loanroute.php?lrid=<?php echo $loanLineID; ?>&&empl=<?php echo $empl_idget; ?>&&lStatus=3" >Refused Loans</a>
            <a href="loanroute.php?lrid=<?php echo $loanLineID; ?>&&empl=<?php echo $empl_idget; ?>&&lStatus=4" >Abandoned Loans</a>
            <a href="loanroute.php?lrid=<?php echo $loanLineID; ?>&&empl=<?php echo $empl_idget; ?>&&lStatus=5" >Cleared Loans</a> 
		</div>
   
        <!-- JS for Pagination Table -->
        <link rel="stylesheet" href="css/paginationTable.css">
        
        <link href="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css" rel="stylesheet">   
        <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
        <link rel="stylesheet" href="http://cdn.datatables.net/1.10.2/css/jquery.dataTables.min.css">
        <script type="text/javascript" src="http://cdn.datatables.net/1.10.2/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        
        <!-- Main Container -->
        <div class="containerOverride">
        <!-- Page Heading -->
        <h3 class="actCusttHeading"><?php echo $lStatusHeading; ?> LOANS</h3>
        <!-- Export Loan Data -->	    
        <div class="exportCdata">
        <form class="export" action="rep_export.php" method="post">
            <!-- Export Button -->	
            <input type="submit" style="background-color: #4682B4 !important; color: #ffffff;" name="export_rep" value="Export Employees Data" />				
        </form>
        </div>
        
        <!-- TABLE: Loans -->
        <table id="myTable" class="table table-striped table-bordered table-responsive table-hover" >
		<thead>
			<tr>
                <th scope="col">Loan No.</th>
				<th scope="col">Customer</th>
				<th scope="col">Loan Period</th>
				<th scope="col">Principal</th>
				<th scope="col">Interest</th>
				<th scope="col">Remaining</th>
				<th scope="col">Issued on</th>
			</tr>
		</thead>
        <tbody> 
        <?php $count = 0;
		      while($row_loans = mysqli_fetch_assoc($query_loans)) { 
              $loan_balances = getLoanBalance($db_link, $row_loans['loan_id']); ?>
		<tr>  
            <td data-label="Loan No">
                <a href="loan.php?lid=<?php echo $row_loans['loan_id']; ?>&&empl=<?php echo $empl_idget; ?>"><?php echo $row_loans['loan_no']; ?></a>
            </td>
            
			<td data-label="Customer"><?php  echo $row_loans['cust_name']; ?>
            <a href="customer.php?cust=<?php echo $row_loans['cust_id']; ?>"><?php echo $row_loans['cust_no']; ?></a>
            </td>
            
            <td data-label="Loan Period"><?php  echo $row_loans['loan_period']; ?></td>
			<td data-label="Peincipal"><?php echo number_format($loan_balances['pdue']).' '.$_SESSION['set_cur']; ?></td>
            
			<td data-label="Interest"><?php echo number_format($loan_balances['idue']).' '.$_SESSION['set_cur']; ?></td>
            
			<td data-label="Remaining"><?php echo number_format($loan_balances['balance']).' '.$_SESSION['set_cur']; ?></td>
            <td data-label="Issued On"><?php echo date("d.m.Y", $row_loans['loan_dateout']); ?></td>  
		</tr> 
        <?php       // Export Array
					array_push($_SESSION['rep_export'], array("Loan No." => $row_loans['loan_no'], "Customer" => $row_loans['cust_name'].' ('.$row_loans['cust_no'].')', "Status" => $row_loans['loanstatus_status'],"Loan Period" => $row_loans['loan_period'], "Principal" => $loan_balances['pdue'], "Interest" => $loan_balances['idue'], "Remaining" => $loan_balances['balance'], "Issued on" => date("d.m.Y", $row_loans['loan_dateout'])));
        $count++;   }	?>
        </tbody>  
        </table> 
        <?PHP /* echo $count.' active customer'; if ($count != 1) echo 's'; */ ?>
        <hr class="new1" style="border-top: 1px solid #FB788E;">		
        </div>
        <!-- include Footer-->
        <?php include 'views/partial/footer.php'; ?>
        <!-- include JS for Responsive Menu -->
        <script src="js/atcMFmainJS.js"></script>
</body>
        <!-- JS for pagination Table -->
        <script>
        $(document).ready(function(){
            $('#myTable').dataTable();
        });
        </script>
</html>